package gov.va.med.mhv.sso;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.PortalSessionThreadLocal;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.AutoLogin;
import com.liferay.portal.security.auth.AutoLoginException;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;

import gov.va.med.mhv.common.api.dto.PatientDTO;
import gov.va.med.mhv.common.api.dto.UserProfileDTO;
import gov.va.med.mhv.common.api.enumeration.FieldTestEnum;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.sso.SystemDownException.ErrorCodeEnum;
import gov.va.med.mhv.usermgmt.common.dto.FieldTestDTO;
import gov.va.med.mhv.usermgmt.service.AccountValidatorService;
import gov.va.med.mhv.usermgmt.service.MviTreatmentFacilityUpdator;
import gov.va.med.mhv.usermgmt.service.UserMgmtService;

/**
 * Created by DNS on 10/26/15.
 */
public class LegacyAutoLogin implements AutoLogin {

	private static final Log logger = LogFactoryUtil.getLog(LegacyAutoLogin.class);

	private static final Object HTTP_SESSION_ERROR = "java.io.IOException: Unable to access the clients http session";

	public static final String ATTR_SCREEN_NAME = "screenName";
	public static final String ATTR_USER_PROFILE = "userProfile";
	public static final String ATTR_PATIENT = "patient";
	public static final String ATTR_SHOW_DELEGATE_USER_TEXT = "showDelegateUserText";
	public static final String ATTR_DELEGATE_ID = "delegateID";			// The user that can act in behalf of a delegator
	public static final String ATTR_DELEGATOR_IDS = "delegatorIDsList";	// The users that are allowing the delegate act on their behalf
	private static final String ATTR_MHV_API_ERROR_CODE = "mhvapiErrorCode";

	// Values used the in the 'status' column of the 'ipa' table in the database
	private static final String DB_VAL_AUTHENTICATED = "Authenticated";
	private static final String DB_VAL_UNAUTHENTICATED = "Unauthenticated";

	public static final String VAR_USER_ROLE = "MHV_VAR";

	private UserMgmtService userMgmtService = null;

	private AccountValidatorService accountValidatorService;

	@Autowired
	@Qualifier("treatmentFacilityUpdator")
	private MviTreatmentFacilityUpdator mviIntegrationService;
	

	
	/**
	 * handleException: Handles the exception reported during the auto login process.
	 * @param request
	 * @param response
	 * @param e
	 * @return String The array of login details.
	 * @throws AutoLoginException
	 */
	public String[] handleException(HttpServletRequest request, HttpServletResponse response, Exception e) throws AutoLoginException {
		logger.error("Error encountered by auto login process: " + e.getMessage(), e);

		// now we'll just return null so that it does not do any auto login stuff:

		return null;
	}

	/**
	 * login: Handles the actual auto-login process.
	 * @param request
	 * @param response
	 * @return The array of login details.
	 * @throws AutoLoginException
	 */
	@Override
	public String[] login(HttpServletRequest request, HttpServletResponse response) throws AutoLoginException {
		String[] credentials = null;

		if(logger.isDebugEnabled()) {
			logger.debug("Entering login method.");
			logger.debug("Remote Address: " + request.getRemoteAddr());
		}

		long companyId = PortalUtil.getCompanyId(request);

		HttpSession session = request.getSession();
		ObjectMapper mapper = new ObjectMapper();


		
		try {
			User user = null;

			String username = (String)request.getAttribute("MHV_EA_UNAME");
			String csid = (String)request.getAttribute("MHV_EA_CSID");
			String userHash = (String)request.getAttribute("MHV_EA_HASH");
			String icn = (String)request.getAttribute("MHV_EA_ICN");
			String va_eauth_isdelegate = (String)request.getAttribute("MHV_EA_IS_DELEGATE");
			boolean isDelegate = "true".equals(va_eauth_isdelegate);
			String va_eauth_isdelegate_custom = (String)request.getAttribute("MHV_EA_IS_DELEGATE_CUSTOM");
			boolean isDelegateCustom = "true".equals(va_eauth_isdelegate_custom);
			Long userID = null;

			// TODO - debug only - remove when done with dev work
			if (username != null) {
				System.out.println("LegacyAutoLogin:  login():  #############  username            = " + username);
				System.out.println("LegacyAutoLogin:  login():  #############  csid                = " + csid);
				System.out.println("LegacyAutoLogin:  login():  #############  icn                 = " + icn);
				System.out.println("LegacyAutoLogin:  login():  #############  va_eauth_isdelegate = " + va_eauth_isdelegate);
				System.out.println("LegacyAutoLogin:  login():  #############  va_eauth_isdelegate_custom = " + va_eauth_isdelegate_custom);
				System.out.println("LegacyAutoLogin:  login():  #############  isDelegate = " + isDelegate);
				System.out.println("LegacyAutoLogin:  login():  #############  isDelegateCustom = " + isDelegateCustom);
			}


			logger.debug("UserName: "+ username);

			
			if(username !=null && username.length() > 0) {
				user = UserLocalServiceUtil.getUserByScreenName(companyId, username);

				if(user != null) {
					if(logger.isDebugEnabled() && user != null) {
						logger.debug(String.format("Liferay User Found having ID: %d and Screen Name: %s", user.getUserId(), user.getScreenName()));
						logger.debug("User ICN: " + icn);
						logger.debug("User Hash: " + userHash);
						logger.debug("User CSID: " + csid);
					}

					session.setAttribute(ATTR_SCREEN_NAME, username);

					this.isUserInactive(username);
					session.setAttribute(ATTR_SCREEN_NAME, username);

					this.isUserInactive(username);					
					credentials = new String[] {String.valueOf(user.getUserId()), user.getPassword(), String.valueOf(user.isPasswordEncrypted())};

					UserProfileDTO authenticatedMhvUserProfile = this.getUserProfile(username);

					if (authenticatedMhvUserProfile != null) {

						userID = authenticatedMhvUserProfile.getId();
						System.out.println("LegacyAutoLogin:  login(): Setting ATTR_USER_PROFILE: userID:: "+userID);
						session.setAttribute(ATTR_USER_PROFILE, mapper.writeValueAsString(authenticatedMhvUserProfile));

						PatientDTO authenticateMhvPatient = (authenticatedMhvUserProfile != null)
								? this.getPatient(authenticatedMhvUserProfile.getId()) : null;

						if (authenticateMhvPatient != null) {
							session.setAttribute(ATTR_PATIENT, mapper.writeValueAsString(authenticateMhvPatient));
						}
						
						if (csid != null) {
							authenticatedMhvUserProfile.setSignInPartners(csid);
						}

						//this.doPostLoginUpdateUser(authenticatedMhvUserProfile.getId());
						processFacilitiesUpdate(authenticatedMhvUserProfile);
						processLastLogin(authenticatedMhvUserProfile);
						

						if(hasVARAccess(authenticateMhvPatient)) {
							System.out.println(" *** ABOUT TO SET VAR ROLE ************");
							session.setAttribute(VAR_USER_ROLE, VAR_USER_ROLE);
							if(logger.isInfoEnabled())
								logger.info("User Profile : " + authenticatedMhvUserProfile.getUserName() + " is set for VAR ACCESS ");
						}


					}
				}
			}
		} catch (AutoLoginException ale) {
			if(session != null && ale.getCause() instanceof SystemDownException) {
				session.setAttribute(ATTR_MHV_API_ERROR_CODE, ((SystemDownException)ale.getCause()).getErrorCode());
			}
			throw ale;

		}catch (Exception e) {
			logger.error("LegacyAutoLogin Exception: " + e.getMessage(), e);
			throw new AutoLoginException("Error processing LegacyAutoLogin.", e);
		}

		if(logger.isDebugEnabled()) {
			logger.debug("Exiting login method.");
		}

//		credentials[0] = String.valueOf(10728);
//		credentials[1] = "AAAAoAAB9AC1H7t95P/IMQxT9eyUjojAsDk53jaPEW7PCdcn";
//		credentials[2] = Boolean.TRUE.toString();

		return credentials;
	}

	private void processLastLogin(UserProfileDTO user) {
		//JAZZ # 111941 - Remote ID Proofing - Last Login
		if(user.getCurrentLogin()!=null) {
			user.setLastLogin(user.getCurrentLogin());
		}
		//Jazz136316 Logout box date time change
		user.setCurrentLogin(new Date());
		try {
			accountValidatorService.saveUserProfile(user);
		} catch (MHVException e) {
			e.printStackTrace();
		}
	}
	
	//JAZZ # 128616 - Process Facilities Update
    private void processFacilitiesUpdate(UserProfileDTO user) {
		boolean sameDay = false;
		
		PatientDTO patient = accountValidatorService.getPatientForUser(user.getId());;
		
		//02/1/2016: We need to check to see if patientDTO exists before doing the facility update.
		if(patient != null) {
			if(patient.getLastFacilitiesUpdateDateTime() != null) {
				Calendar now = Calendar.getInstance();
				//now.setTime(now.getTime() - 1000*60*60*24);
				Calendar lastFacilitiesUpdate = Calendar.getInstance();
				lastFacilitiesUpdate.setTime(patient.getLastFacilitiesUpdateDateTime());
	
				sameDay = now.get(Calendar.YEAR) == lastFacilitiesUpdate.get(Calendar.YEAR) &&
					now.get(Calendar.DAY_OF_YEAR) == lastFacilitiesUpdate.get(Calendar.DAY_OF_YEAR);
			}
			if(!sameDay) {
				try {
					//Jazz Id: 230989 - adding HL7v3 Version code in MVI Request Header.
					mviIntegrationService.updateTreatmentFacilitiesForExistingPatients(patient);
				} catch (MHVException e) {
					logger.error("Error updating facilities for patient.", e);
				}
			}
		}
    }

	private UserProfileDTO getUserProfile(String screenName) throws AutoLoginException {
		UserProfileDTO userProfile = null;
         try {

             userProfile = getUserManagementService().getUserProfile(screenName);

         } catch (Exception ex) {
        	 ex.printStackTrace();
                         if (!HTTP_SESSION_ERROR.equals(ex.getMessage())) {
                                         logger.error(ErrorCodeEnum.USER_MANAGMENT_FAILURE_USER_PROFILE.toString()+", Screename:"+ screenName, ex);
                                         throw new AutoLoginException("Error getting User Profile from User Management Service.",
                                                                         new SystemDownException(ErrorCodeEnum.USER_MANAGMENT_FAILURE_USER_PROFILE, ex));

                         }
         }

         return userProfile;
     }


	private PatientDTO getPatient(Long userProfileId) throws AutoLoginException {
        try {
            return getUserManagementService().getPatient(userProfileId);
        } catch (Exception ex) {
            logger.error(ErrorCodeEnum.USER_MANAGMENT_FAILURE_PATIENT.toString(), ex);
            throw new AutoLoginException("Error getting Patient from User Management Service.", new SystemDownException(ErrorCodeEnum.USER_MANAGMENT_FAILURE_PATIENT, ex));
        }
	}

	private void doPostLoginUpdateUser(Long userProfileId) throws AutoLoginException {
        try {
                        this.userMgmtService.postLoginUpdateUser(userProfileId);
        } catch (MHVException ex) {
        	logger.error(ErrorCodeEnum.USER_MANAGMENT_FAILURE_POST_LOGIN_UPDATE.toString(), ex);
            throw new AutoLoginException("Error performing post login updates for User.", new SystemDownException(ErrorCodeEnum.USER_MANAGMENT_FAILURE_POST_LOGIN_UPDATE, ex));
        }
	}

	private UserMgmtService getUserManagementService() {
        if (this.userMgmtService == null) {
        	this.userMgmtService = (UserMgmtService) ApplicationContextProvider.getApplicationContext().getBean("userMgmtServiceProxy");
        }
        return this.userMgmtService;
	}

	private void isUserInactive(String screenName) throws AutoLoginException {
        try {
            if (getAccountValidatorService().isUserInactive(screenName)) {
            	logger.error(screenName + ":: is deactivated");
                throw new AutoLoginException(new UserDeactivatedException(String.format("User: %s is not active.", screenName)));
            }
        } catch (MHVException e) {
            // something failed with the web service. fail authentication.
        	logger.error(ErrorCodeEnum.ACCOUNT_VALIDATOR_FAILURE_IS_USER_INACTIVE.toString(), e);
            throw new AutoLoginException("Error getting User Profile from User Management Service.", new SystemDownException(ErrorCodeEnum.ACCOUNT_VALIDATOR_FAILURE_IS_USER_INACTIVE, e));
        }
	}

	private AccountValidatorService getAccountValidatorService() {
        if (this.accountValidatorService == null) {
            this.accountValidatorService = (AccountValidatorService) ApplicationContextProvider.getApplicationContext().getBean("accountValidatorServiceProxy");
        }

        return this.accountValidatorService;
	}


	private boolean hasVARAccess(PatientDTO patient) {
		boolean hasVarAccess =false;
		try {
			hasVarAccess = getUserManagementService().checkVAREligibilityForPatient(patient.getId());
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return false;
		}

		if(logger.isInfoEnabled())
			logger.info("User Profile id "+patient.getUserProfileId() + " VAR Access status is: " +  hasVarAccess);

		return hasVarAccess;
	}


}
